#include <Arduino.h>

#define RXD1 10 // some random pin
#define TXD1 21

#define RXD2 22
#define TXD2 20 // Some random pin

#define NODE_ID 4 // Drive 1

#define GET_CMD(b) (b >> 4)
#define GET_NODE_ID(b) (b & 0x0F)

#define COMMAND_CONTROL_RESET 0x00
#define COMMAND_CONTROL_STATUS 0x01
#define COMMAND_CONTROL_ACK 0x02
#define COMMAND_CONTROL_CTS 0x03
#define COMMAND_CONTROL_RECEIVE 0x04
#define COMMAND_CONTROL_CANCEL 0x05
#define COMMAND_DATA_SEND 0x06
#define COMMAND_CONTROL_NAK 0x07
#define COMMAND_CONTROL_READY 0x0D

#define RESPONSE_CONTROL_STATUS 0x08
#define RESPONSE_CONTROL_ACK 0x09
#define RESPONSE_CONTROL_CANCEL 0x0A
#define RESPONSE_DATA_SEND 0x0B
#define RESPONSE_CONTROL_NAK 0x0C

#define ACK(b) (0x90 + b)

byte status[6] = {0x84, 0x00, 0x04, 0x01, 0x40, 0x45};

byte testBlock[1028] =
    {
        0xB4, 0x04, 0x00, // Header

        0x78, 0x32, 0x6f, 0xfd, 0xcd, 0x16, 0xc8, 0x21, 0x76, 0xc8, 0x11, 0x89,
        0x18, 0x01, 0x0e, 0x00, 0xcd, 0x1a, 0xfd, 0xc3, 0x13, 0xc8, 0x01, 0x00,
        0x00, 0xcd, 0x20, 0xfd, 0x01, 0xe0, 0x01, 0xcd, 0x20, 0xfd, 0x01, 0x05,
        0x07, 0xcd, 0x20, 0xfd, 0x3e, 0x00, 0x21, 0x00, 0x1b, 0xcd, 0x29, 0xfd,
        0x3e, 0x01, 0x21, 0x00, 0x38, 0xcd, 0x29, 0xfd, 0x3e, 0x02, 0x21, 0x00,
        0x18, 0xcd, 0x29, 0xfd, 0x3e, 0x03, 0x21, 0x00, 0x00, 0xcd, 0x29, 0xfd,
        0x3e, 0x04, 0x21, 0x00, 0x20, 0xcd, 0x29, 0xfd, 0xcd, 0x38, 0xfd, 0x21,
        0x00, 0x20, 0x3e, 0xf0, 0x11, 0x10, 0x00, 0xcd, 0x26, 0xfd, 0x21, 0x10,
        0x20, 0x3e, 0x7f, 0x11, 0x10, 0x00, 0xcd, 0x26, 0xfd, 0x01, 0x17, 0x1f,
        0x11, 0x00, 0x00, 0x21, 0x00, 0x38, 0xcd, 0x36, 0xfc, 0xc9, 0x42, 0x4c,
        0x4f, 0x43, 0x4b, 0x20, 0x30, 0x20, 0x4c, 0x6f, 0x61, 0x64, 0x65, 0x64,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00,

        0x04 // Checksum

};

void setup()
{
  pinMode(2, OUTPUT);
  pinMode(4, OUTPUT);
  pinMode(13, OUTPUT);
  pinMode(TXD1, OUTPUT_OPEN_DRAIN);

  digitalWrite(TXD1, HIGH); // So the AdamNet doesn't contend.
  digitalWrite(2, 1); // turn off LEDs
  digitalWrite(4, 1);
  digitalWrite(13, 1);
  
  Serial.begin(921600);
  Serial2.begin(62500, SERIAL_8N1, RXD2, TXD2, true);

  Serial.printf("\n\n\n#FujiNet Test #6 - Boot Block\n\n\n");
}

void drain()
{
  while (Serial2.available()) { Serial2.flush(); }
}

void wait_for_idle()
{
  bool isIdle = false;
  unsigned long start, current;

  do
  {
    drain();

    start = micros();

    while ((!Serial2.available()) && (isIdle == false))
    {
      current = micros();
      if ((current - start) > 900)
        isIdle = true;
    }

  } while (isIdle == false);
}

void adamnet_send(unsigned char b)
{
  // Send Start Bit
  digitalWrite(TXD1,LOW);
  ets_delay_us(16);

  // Send Data Bits
  for (byte mask = 0x01; mask>0; mask <<= 1)
  {
    if (b & mask)
      digitalWrite(TXD1,HIGH);
    else
      digitalWrite(TXD1,LOW);
    
    ets_delay_us(16);
  }

  // Send Stop Bit
  digitalWrite(TXD1,HIGH);
  ets_delay_us(16);
}

void adamnet_send_bytes(byte *b, int len)
{
  while (len > 0)
  {
    adamnet_send(*b++);
    len--;
  }
}

byte adamnet_recv()
{
  byte ret[1];
  Serial2.readBytes(ret,1);
  Serial.printf("Received: %02X\n",ret[0]);
  return ret[0];
}

unsigned char wait_ack()
{
  char ret[1];
  Serial2.readBytes(ret, 1);
  return ret[0];
}

void command_control_status()
{
  ets_delay_us(150);
  Serial.printf("Sending Status\n");
  adamnet_send_bytes(status,sizeof(status));
  drain();
  wait_ack();
}

void command_data_send()
{
  byte b;

  ets_delay_us(150);
  adamnet_send(ACK(NODE_ID)); // Go ahead and let adam know we have the block
  b = GET_CMD(adamnet_recv()); // Get the CTS
  if (b == COMMAND_CONTROL_CTS) // We got CTS, send out test block
  {
    adamnet_send_bytes(testBlock,sizeof(testBlock));
    drain();
    b = GET_CMD(adamnet_recv());

    Serial.printf("Writing block 0\n\n");
    for (int i=0;i<sizeof(testBlock);i++)
      Serial.write("%02X ");
    Serial.printf("\n\n");

    if (b == 0x02)
    {
      // Success
    }
    else if (b == 0x0d)
    {
      // Failed, as if it didn't get the CTS, it wants us to retry
    }
    else
    {
      // Also failed
    }
  }
  else
  {
    // CTS didn't happen, emit error, and change status to 0x41.
  }
}

void command_control_ready()
{
  byte transferCommand[9];

  adamnet_send(ACK(NODE_ID)); // Send ACK of Ready to Adam
  drain();

  Serial2.readBytes(transferCommand,sizeof(transferCommand)); // Get the transfer command

  Serial.printf("READY: TRANSFER COMMAND: %02X %02X %02X %02X %02X %02X %02X %02X %02X\n",transferCommand[0], transferCommand[1], transferCommand[2], transferCommand[3], transferCommand[4], transferCommand[5], transferCommand[6], transferCommand[7], transferCommand[8]);

  switch (GET_CMD(transferCommand[0]))
  {
    case COMMAND_DATA_SEND:
      command_data_send();
      break;
    default:
      // ignore for now.
      break;
  }

}

void command(unsigned char cmd)
{
  Serial.printf("command(%02X)\n",cmd);
  switch (cmd)
  {
  case COMMAND_CONTROL_STATUS:
    command_control_status();
    break;
  case COMMAND_CONTROL_READY:
    command_control_ready();
    break;
  }
}

void loop()
{
  if (Serial2.available())
  {
    unsigned char b = Serial2.read();
    unsigned char dev = GET_NODE_ID(b);
    unsigned char cmd = GET_CMD(b);

    Serial.printf("%02X ",b);

    if (dev == NODE_ID) // me
    {
      digitalWrite(4,0);
      command(cmd);
      digitalWrite(4,1);
    }
  }
  wait_for_idle();
}